function sp500 = import_sp500_bloomberg(file_name)
% --------------------------------------------------------------------------------------------------
% Import time-series of S&P500 index
% --------------------------------------------------------------------------------------------------
% file_name         ... Excel file name with S&P500 time-series
% --------------------------------------------------------------------------------------------------
% sample call: import_sp500_bloomberg('c:/thesis/data/bloomberg/s&p500 index monthly.xls');
% --------------------------------------------------------------------------------------------------

% Import data
[num, txt] = xlsread(file_name, 1, 'A3:B60000');

% Calculate 1-year trailing returns
return1yr = [zeros(12,1); (num(13:end)-num(1:end-12))./num(1:end-12)];

% Put data into structure
sp500 = struct('dates', datenum(txt), 'price', num, 'return1yr', return1yr);